﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Icon Info class used for icon association.
    /// </summary>
    [DataContract]
    public class IconAssociationInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        /// <value>
        /// The icon.
        /// </value>
        [DataMember]
        public IconInfo Icon { get; set; }

        /// <summary>
        /// Gets or sets the code. If the icon is association then "Yes" else "No".
        /// </summary>
        /// <value>
        /// The code.
        /// </value>
        [DataMember]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the icon patient or room bed description.
        /// </summary>
        /// <value>
        /// The icon patient or room bed description.
        /// </value>
        [DataMember]
        public string IconPatientOrRoomBedDescription { get; set; }

        /// <summary>
        /// Gets or sets the icon patient or room bed image bytes.
        /// </summary>
        /// <value>
        /// The icon patient or room bed image bytes.
        /// </value>
        [DataMember]
        public string IconPatientOrRoomBedImageBytes { get; set; }

        /// <summary>
        /// Gets or sets the icon patient or room bed mouse over text.
        /// </summary>
        /// <value>
        /// The icon patient or room bed mouse over text.
        /// </value>
        [DataMember]
        public string IconPatientOrRoomBedMouseOverText { get; set; }

        #endregion
    }
}
